
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL.View
{
    internal class Instructor : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.View.Instructor, BO.View.Instructor>
    {
        internal Instructor(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal Instructor(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.View.Instructor.DBD) { }

        internal BO.View.Instructor RestoreTopOne(BO.Instructor.Search Search)
        {
            return InternalRestoreOne((int)DBD.View.Instructor.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["UserID"].Value = Search.UserID;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["Surename"].Value = Search.Surename;
                Command["Forename"].Value = Search.Forename;
                Command["Email"].Value = Search.Email;
            });
        }

        internal List<BO.View.Instructor> Restore(BO.Instructor.Search Search)
        {
            return InternalRestoreList((int)DBD.View.Instructor.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["UserID"].Value = Search.UserID;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["Surename"].Value = Search.Surename;
                Command["Forename"].Value = Search.Forename;
                Command["Email"].Value = Search.Email;
            });
        }
    }
}
